﻿using System;
using System.Collections.Generic;
using System.Resources;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections.Specialized;
using System.Reflection;
using System.Text;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

/// <summary>
/// Summary description for BasePage
/// </summary>
public abstract class BaseTBIInstrumentPage : Page
{
    //Default values
    private string msgSaveSuccess = "Save Successful.";
    private string msgSaveFail = "Save Failed.";

    #region Constructor

    public BaseTBIInstrumentPage(bool errorOnSavedReceived)
    {
        //Manager Save Notification Event Handler
        _tbiInstrumentManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

        _errorOnSavedReceived = errorOnSavedReceived;
        SuppressSaveMessage = true;
    }
    public BaseTBIInstrumentPage()
    {
        //Manager Save Notification Event Handler
        _tbiInstrumentManager.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

        SuppressSaveMessage = true;
    }

    public string SaveSuccessMessage
    {
        get
        {
            //return "Save Successful.";
            return msgSaveSuccess;
        }

        set
        {
            msgSaveSuccess = value;
        }
    }

    public string SaveFailMessage
    {
        get
        {
            //return "Save Failed.";
            return msgSaveFail;
        }

        set
        {
            msgSaveFail = value;
        }
    }

    protected void BaseTBIInstrumentPage_Load(object sender, EventArgs e)
    {
        CheckNeedStationDivision();
        Response.Cache.SetExpires(DateTime.Now);
        bool _isCPRSLaunced = false;

        if (_tbiInstrumentManager == null) { _tbiInstrumentManager = new TBIInstrumentsManager(); }
        TBIServiceTO _tbiServiceTo = GetTBIServiceTo();

        if (_tbiServiceTo == null)
        {
            Logging.WriteLogToFile("BaseTBIInstrumentPage.PageLoad(): WarningRedirect: _tbiServiceTo is null");
            Response.Redirect("Warning.aspx?err=2", true); 
        }

        if (sender.GetType().BaseType.FullName == "PatientInstrumentsNoMDWS")
        {
            _tbiServiceTo.PatientName = "Last, First Middle";
            _tbiServiceTo.PatientDOB = "01/02/1970";
            _tbiServiceTo.PatientGender = string.Empty;
            _tbiServiceTo.PatientSnum = "123456789";
            _tbiServiceTo.PatientICN = "123456789";
            _tbiServiceTo.PatientDFN = "1316";
            _tbiServiceTo.STA6N = string.Empty;
            _tbiServiceTo.UserName = "Test Doctor";
            _tbiServiceTo.PatientAdmitTimeStamp = string.Empty;
        }
        else
        {
            if (getCurrentServiceToUse() == "VIA")
            {
                try
                {
                    _isCPRSLaunced = _tbiInstrumentManager.LoadTBI_VIAService(_tbiServiceTo); // VIA
                }
                catch (Exception x)
                {
                    _isCPRSLaunced = false;
                    Logging.WriteLogToFile(x);
                }
                if (!_isCPRSLaunced) 
                {
                    Logging.WriteLogToFile("BaseTBIInstrumentPage.PageLoad(): WarningRedirect: VIA !_isCPRSLaunced");
                    Response.Redirect("Warning.aspx?err=12345", true); 
                }
            }
            else
            {
                _tbiInstrumentManager.DisconnectSite(); // Only for MDWS
                _isCPRSLaunced = _tbiInstrumentManager.LoadTbiService(_tbiServiceTo); // MDWS
                if (!_isCPRSLaunced) 
                {
                    Logging.WriteLogToFile("BaseTBIInstrumentPage.PageLoad(): WarningRedirect: MDWS !_isCPRSLaunced");
                    Response.Redirect("Warning.aspx?err=1", true); 
                }
            }
        }

        AddtoSessionTBIServiceTo(_tbiServiceTo);
        AddtoViewStateTBIServiceTo(_tbiServiceTo);

        Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
        if (labelUser != null)
        {
            labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiServiceTo.UserName);
        }

        _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;
    }

    #endregion Constructor

    #region Properities

    private bool _errorOnSavedReceived;
    private Dictionary<string, string> _OnStartupAlertErrorCollection;

    protected bool _TestingAllowSSNConfirmByPass = false;

    protected TBIInstrumentsManager _tbiInstrumentManager = new TBIInstrumentsManager();

    public bool ReadOnly { get; set; }
    public bool AllowInsert { get; set; }
    public bool AllowDelete { get; set; }
    public bool AllowUpdate { get; set; }
    public bool BusinessObjectSaveEventReceived { get; set; }
    public bool IsSaveSuccess { get; set; }
    public bool SuppressSaveMessage { get; set; }


    #endregion Properties

    #region Abstract Methods



    #endregion Abstract Methods

    #region Public Methods

    public TBIServiceTO GetTBIServiceTo()
    {
        TBIServiceTO tbiServiceTo = null;

        if (!Page.IsPostBack)
        { tbiServiceTo = GetTBIServiceToFromSession(); }
        else
        { tbiServiceTo = GetTBIServiceToFromViewState(); }

        return tbiServiceTo;
    }

    /// <summary>
    /// Select returns the base application path.
    /// </summary>
    /// <param name="context">Context object</param>
    /// <returns>Returns the base application path.</returns>
    public static string RootPath(HttpContext context)
    {
        string urlSuffix = context.Request.Url.Authority + context.Request.ApplicationPath;
        return context.Request.Url.Scheme + @"://" + urlSuffix + "/";
    }

    public static NameValueCollection DecryptQueryString(string queryString)
    {
        NameValueCollection myColl = new NameValueCollection();
        myColl.Add("a", "1");
        return myColl;
    }

    public static string EncryptQueryString(NameValueCollection queryString)
    {
        string myString = "";
        return myString;
    }

    /// <summary>
    /// You must pass in a string that uses the QueryStringHelper.DELIMITER as the delimiter.
    /// This will also append the "?" to the beginning of the query string.
    /// </summary>
    /// <param name="queryString"></param>
    /// <returns></returns>
    public static string EncryptQueryString(string queryString)
    {
        string qs = "";
        return qs;
    }

    /// <summary>
    /// getCurrentServiceToUse: pulls from settings.  If null, returns MDWS, else returns either MDWS or VIA
    /// </summary>
    /// <returns></returns>
    protected string getCurrentServiceToUse()
    {
        return Helpers.getCurrentServiceToUse();  
    }

    //#region Exception Logging
    protected Exception HandleTBIException(Exception exception, string screenName, string eventId, string functionname)
    {
        return Helpers.HandleTBIException(exception, screenName, eventId, functionname);
    }
    //protected Exception Helpers.HandleTBIException(Exception exception, string screenName, string eventId, string functionname)
    //{

    //    WriteLogToFile(exception, screenName, eventId, functionname);

    //    return exception;
    //}

    //private void WriteLogToFile(Exception ex, string _screenName, string _eventId, string _functionname)
    //{
    //    string path = GetLogLocation();
    //    string flatmessage = null;

    //    if (ex != null)
    //    {
    //        if (ex.Message != null && ex.InnerException != null)
    //        {
    //            flatmessage = "TBI INSTRUMENT ERROR:: " + ex.Message.ToString() + " :::SCREENNAME= " + _screenName + " :::INNER EXCEPTION= " + ex.InnerException.ToString() + ":::Function=" + _functionname;
    //        }
    //        if (flatmessage == null)
    //        {
    //            if (ex.Message == null && ex.InnerException == null)
    //            {
    //                flatmessage = "TBI INSTRUMENT ERROR:: ex.Message=null:::SCREENNAME= " + _screenName + " :::INNER EXCEPTION=null:::Function=" + _functionname;
    //            }
    //            else if (ex.Message != null && ex.InnerException == null)
    //            {
    //                flatmessage = "TBI INSTRUMENT ERROR:: " + ex.Message.ToString() + " :::SCREENNAME= " + _screenName + ":::INNER EXCEPTION=null:::Function=" + _functionname;
    //            }
    //            else if (ex.Message == null && ex.InnerException != null)
    //            {
    //                flatmessage = "TBI INSTRUMENT ERROR:::ex.Message=null:: SCREENNAME= " + _screenName + " :::INNER EXCEPTION= " + ex.InnerException.ToString() + ":::Function=" + _functionname;
    //            }
    //        }
    //    }
    //    //flatmessage = "HEATH TEST";
    //    //write error to flat file on machine drive
    //    if (flatmessage != null)
    //    {
    //        Logging.WriteLogToFile(flatmessage);

    //        //if (path != null)
    //        //{
    //        //    if (path.Length > 0)
    //        //    {
    //        //        try
    //        //        {
    //        //            BitFactory.Logging.Logger l = new BitFactory.Logging.FileLogger(path);
    //        //            l.LogError(flatmessage);
    //        //        }
    //        //        catch
    //        //        {
    //        //        }
    //        //    }
    //        //}
    //    }
    //}

    //public static string GetLogLocation()
    //{
    //    return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + ".log";
    //}


    //#endregion

    #endregion Public Methods

    #region Protected Methods

    #region VIA methods
    protected void AddtoSessionTBIVIAServiceTo(VIAInstrumentsManager.TBIServiceTOVIA tbiServiceTo)
    {
        if (Session["ConfirmedSSN"] != null)
        {
            if (Session["ConfirmedSSN"].ToString() != tbiServiceTo.PatientSSN)
            {
                Logging.WriteLogToFile("BaseTBIInstrumentPage.AddtoSessionTBIVIAServiceTo(): WarningRedirect: SSN Mismatch");
                //corrupted application context display error message to user
                Response.Redirect("Warning.aspx?err=11");
            }
        }

        Session["TBIServiceTO"] = tbiServiceTo;
    }

    protected VIAInstrumentsManager.TBIServiceTOVIA GetTBIVIAServiceToFromSession()
    {
        return Session["TBIServiceTO"] as VIAInstrumentsManager.TBIServiceTOVIA;
    }
    #endregion

    protected TBIServiceTO GetTBIServiceToFromSession()
    {
        return Session["TBIServiceTO"] as TBIServiceTO;
    }

    protected TBIServiceTO GetTBIServiceToFromViewState()
    {
        return ViewState["TBIServiceTO"] as TBIServiceTO;
    }

    protected void AddtoSessionTBIServiceTo(TBIServiceTO tbiServiceTo)
    {
        if (Session["ConfirmedSSN"] != null)
        {
            if (Session["ConfirmedSSN"].ToString() != tbiServiceTo.PatientSnum)
            {
                Logging.WriteLogToFile("BaseTBIInstrumentPage.AddtoSessionTBIServiceTo(): WarningRedirect: SSN Mismatch");
                //corrupted application context display error message to user
                Response.Redirect("Warning.aspx?err=11");
            }
        }

        Session["TBIServiceTO"] = tbiServiceTo;
    }

    protected void AddtoSessionSSN(string ssn)
    {
        //This setting is only saved once in a session to be used for preventing cross-instance data sharing
        if (Session["ConfirmedSSN"] == null)
        {
            Session["ConfirmedSSN"] = ssn;
        }
    }

    protected void AddtoViewStateTBIServiceTo(TBIServiceTO tbiServiceTo)
    {
        ViewState["TBIServiceTO"] = tbiServiceTo;
    }

    /// <summary>
    /// Calls the TBIInstrumentsManager and confirms that the instrument is active, otherwise - redirect to main listing page.
    /// </summary>
    /// <param name="surveyId"></param>
    protected void CheckActiveStatus(int surveyTypeId)
    {
        if (_tbiInstrumentManager.IsInstrumentActive(surveyTypeId))
        {
        }
        else
        {
            Response.Redirect("PatientInstrumentsMain.aspx", true);
        }
    }

    #endregion

    #region Overrides

    protected override void OnPreInit(EventArgs e)
    {
        //get theme from user profile
        this.Theme = "TBIInstruments";
    }

    protected override void OnInit(EventArgs e)
    {
        base.OnInit(e);

        if (!isQueryStringValid())
        {
            //redirect to error handling page
            Response.Redirect("../ErrorPage.aspx?id=qs");
        }

    }

    protected override void OnPreRender(EventArgs e)
    {
        if (!SuppressSaveMessage)
        {
            RenderStartUpMessage(IsSaveSuccess);
        }

        base.OnPreRender(e);
    }

    #endregion Overrides

    #region Virtual Methods

    protected virtual void NoAccessToPage()
    {
        //You do not access to the system.
        //If a page has more than one capability you should override this method because a user could
        //have access to one section but not another so you do not want them to get an error
        Response.Redirect("ErrorPage.aspx?id=100");
        //throw new AccessViolationException("You do not have access to this screen.");
    }

    public virtual void CustomReadOnlyLogic(string capabilityName)
    {
        //Override this method in a page that has custom logic for non standard controls on the screen.
    }

    /// <summary>
    /// The default implementation will make all controls disabled.
    /// If you have more than one capability associated with a page you should override this method
    /// with the special logic for each capability in the page.
    /// </summary>
    /// <param name="capabilityName"></param>
    /// <param name="controls"></param>
    public virtual void MakeFormReadOnly(string capabilityName, ControlCollection controls)
    {
        ReadOnly = true;

        SetControlsEnableState(controls, false);

        CustomReadOnlyLogic(capabilityName);
    }

    public virtual void EnableAllControls(ControlCollection controls)
    {
        SetControlsEnableState(controls, true);
    }

    #endregion Virtual Methods

    #region Private Methods

    private void SetControlsEnableState(ControlCollection controls, bool enabled)
    {

        foreach (Control c in controls)
        {
            if (c is TextBox)
            {
                ((TextBox)c).Enabled = enabled;
            }
            else if (c is RadioButton)
            {
                ((RadioButton)c).Enabled = enabled;
            }
            else if (c is DropDownList)
            {
                ((DropDownList)c).Enabled = enabled;
            }
            else if (c is CheckBox)
            {
                ((CheckBox)c).Enabled = enabled;
            }
            else if (c is RadioButtonList)
            {
                ((RadioButtonList)c).Enabled = enabled;
            }
            else if (c is CheckBoxList)
            {
                ((CheckBoxList)c).Enabled = enabled;
            }
            else if (c is RequiredFieldValidator)
            {
                ((RequiredFieldValidator)c).Enabled = enabled;
            }
            else
            {
                //break
            }

            if (c.HasControls())
            {
                SetControlsEnableState(c.Controls, enabled);
            }
        }
    }

    private Boolean isQueryStringValid()
    {
        //this iterates over querysting parameters
        //this will handle known querystring parameters and validate range, if any not valid range throw exception
        //if unknown parameter is found, throw exception

        Boolean _isValid = true;

        NameObjectCollectionBase.KeysCollection qryString = Request.QueryString.Keys;

        foreach (string qryStringKey in qryString)
        {
            switch (qryStringKey)
            {
                case "q9gtw0":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "yiicf":
                    _isValid = Helpers.isInteger(Request.QueryString[qryStringKey]);
                    break;
                case "xqi4z":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "5Sfty21":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "45vlw93":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "jbPI0202":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;
                case "27trp":
                    _isValid = Helpers.isString(Request.QueryString[qryStringKey]);
                    break;


                default:

                    //do something here   
                    _isValid = false;
                    break;
                //throw new Exception("Unknown querystring parameter. " + qryStringKey);
            }

            if (!_isValid)
            {
                break;
            }
        }

        return _isValid;
    }

    //private SessionFacade _SessionFacade = new SessionFacade();
    private string CreateStartUpMessage(bool isSaveSuccessMessage)
    {

        string Message = string.Empty;

        if (_OnStartupAlertErrorCollection == null && !SuppressSaveMessage)
        {
            if (isSaveSuccessMessage)
            {
                Message = SaveSuccessMessage;
            }
            else
            {
                Message = SaveFailMessage;
            }
        }
        else
        {
            if (_OnStartupAlertErrorCollection != null)
            {
                foreach (KeyValuePair<string, string> item in _OnStartupAlertErrorCollection)
                    Message += item.Value + "\\n";
            }

        }

        return Message;
    }
    /// <summary>
    /// Renders the massage in javascript alert. Modify if needed for section 508 compliance
    /// </summary>
    protected void RenderStartUpMessage(bool IsSaveSuccessMessage)
    {
        StringBuilder sb = new StringBuilder();
        string Message = CreateStartUpMessage(IsSaveSuccessMessage);

        if (Message != string.Empty)
        {
            HiddenField HiddenFieldShowSaveMessage = this.Master.FindControl("HiddenFieldShowSaveMessage") as HiddenField;
            if (HiddenFieldShowSaveMessage != null)
                HiddenFieldShowSaveMessage.Value = "1";

            HiddenField HiddenFieldSaveMessage = this.Master.FindControl("HiddenFieldSaveMessage") as HiddenField;
            if (HiddenFieldSaveMessage != null)
                HiddenFieldSaveMessage.Value = Message;
        }
    }
    #endregion Private Methods

    protected void manager_BOSaveSuccess(object sender, BaseBO.BOSaveSuccessEventArgs e)
    {
        if (!_errorOnSavedReceived)
        {
            BusinessObjectSaveEventReceived = true;
        }
        IsSaveSuccess = (e.SaveStatusArg == BaseBO.SaveStatus.SaveSuccess);
    }

    #region CCOW

    private void CheckNeedStationDivision()
    {
        //DRL - uncomment this to skip the CCOW screen
        //StationDivision = "4429AA";
        if (getCurrentServiceToUse() == "VIA" && string.IsNullOrEmpty(StationDivision))
        {
            Response.Redirect("StationDivisionAuthorization.aspx", true);
        }
    }

    protected string StationDivision
    {
        get
        {
            return Session["StationDivision"] as string;
        }
        set
        {
            Session["StationDivision"] = value;
        }
    }

    #endregion CCOW
}